#version 330
#extension GL_EXT_gpu_shader4 : enable
// some cellular noiseMod01.fsh   by   cody_shader
//https://www.shadertoy.com/view/wtdBWl
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 random2(vec2 st){
    st = vec2( dot(st,vec2(127.1,311.7)),
              dot(st,vec2(269.5,183.3)) );
    return fract(abs(sin(st)*43758.5453123));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 st = gl_FragCoord.xy/iResolution.y;
    st.y -= iTime*0.1;
    
    const float scale = 10.;
    st *= scale;

    vec2 i_st = floor(st);
    vec2 f_st = fract(st);
    
    vec2 m_dist = vec2(100.0);

    for (int y= -1; y <= 1; y++) {
        for (int x= -1; x <= 1; x++) {
            vec2 neighbor = vec2(float(x),float(y));
            vec2 point = random2(i_st + neighbor);
            point = 0.5+0.5*sin(iTime + 6.2831*point);
            vec2 diff = neighbor + point - f_st; 
            float dist = length(diff);
            
            if ( dist < m_dist.x || dist < m_dist.y) {
                if (m_dist.x > m_dist.y) m_dist.x = dist;
                else m_dist.y = dist;
            }
        }
    }
    
    float min_dist = min(m_dist.x, m_dist.y);
    float max_dist = max(m_dist.x, m_dist.y);
    
    float col1 = float(max_dist-min_dist);
    float col2 = float(min_dist*max_dist);
    float col3 = float(cos(max_dist)-sin(min_dist));
    float col4 = float(17.-st.x-min_dist*15.0);
    float col5 = float(st.x-(min_dist/max_dist)*15.0);
    float col6 = float((0.5+0.5*sin((cos(max_dist)-sin(min_dist))*20.0)));
    
    float m1 = mix(col1, col2, .5+.2*sin(iTime*0.7));
    float m2 = mix(col3, col4, .5+.2*sin(iTime*1.3));
    float m3 = mix(col5, col6, .5+.2*sin(iTime*1.9));
    float m4 = mix(col4, m2, m3);
     
    vec3 col7 = vec3(m4,m3,m2);
    vec3 col8 = vec3(m2,m4,m1);
    vec3 col9 = vec3(m1,m2,m3);
    
    vec3 col10 = mix(col7, col8, col7);
    vec3 col = col10;
    gl_FragColor.a = length(gl_FragColor.rgb);
    gl_FragColor = vec4(col,0.314159);
    //gl_FragColor.a = length(gl_FragColor.rgb);
}